% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{st_transform_proj}
\alias{st_transform_proj}
\alias{st_transform_proj}
\alias{st_transform_proj.sfc}
\alias{st_transform_proj}
\alias{st_transform_proj.sf}
\alias{st_transform_proj}
\alias{st_transform_proj.sfg}
\title{Transform or convert coordinates of simple features directly with Proj.4}
\usage{
st_transform_proj(x, crs, ...)

\method{st_transform_proj}{sfc}(x, crs, ...)

\method{st_transform_proj}{sf}(x, crs, ...)

\method{st_transform_proj}{sfg}(x, crs, ...)
}
\arguments{
\item{x}{object of class sf, sfc or sfg}

\item{crs}{object or class \code{crs}, or input to \link[sf]{st_crs} (proj4string, or EPSG code)}

\item{...}{ignored}
}
\description{
Transform or convert coordinates of simple features directly with Proj.4
}
\details{
Transforms coordinates of object to new projection, using Proj.4 and not the GDAL API.

The \code{st_transform_proj} method for \code{sfg} objects assumes that the CRS of the object is available as an attribute of that name.
}
\examples{
library(sf)
p1 = st_point(c(7,52))
p2 = st_point(c(-30,20))
sfc = st_sfc(p1, p2, crs = 4326)
sfc
st_transform_proj(sfc, "+proj=wintri")
library(sf)
nc = st_read(system.file("shape/nc.shp", package="sf"))
st_transform_proj(nc[1,], "+proj=wintri +over")
st_transform_proj(structure(p1, proj4string = "+init=epsg:4326"), "+init=epsg:3857")
}
