% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palette_subsample.R
\name{palette_subsample}
\alias{palette_subsample}
\title{Randomly Subsample HEX Codes}
\usage{
palette_subsample(palette, wanted = 5, random_seed = 36)
}
\arguments{
\item{palette}{(character) Vector of hexadecimal codes like those returned by `palette_extract()` or `palette_sort()`}

\item{wanted}{(numeric) Integer for how many colors should be returned}

\item{random_seed}{(numeric) Integer for `base::set.seed()`}
}
\value{
(character) Vector of hexadecimal codes of user-specified length
}
\description{
Randomly subsample the HEX codes returned by `palette_extract()` or `palette_sort()` to desired length. Can also set random seed for reproducibility.
}
\examples{
# Extract colors from a supplied image
my_colors <- palette_extract(image = system.file("extdata", "lyon-fire.png",
package = "lterpalettefinder"))
       
# Plot that result
palette_ggdemo(palette = my_colors)

# Now randomly subsample
random_colors <- palette_subsample(palette = my_colors, wanted = 5)

# And plot again to show change
palette_ggdemo(palette = random_colors)

}
