% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDesignSurvivals.R
\name{pwexpcuts}
\alias{pwexpcuts}
\title{Piecewise Exponential Approximation to a Survival Distribution}
\usage{
pwexpcuts(S, ...)
}
\arguments{
\item{S}{The survival function of a univariate survival time.}

\item{...}{Additional arguments to be passed to S.}
}
\value{
A list with three components:
\itemize{
\item \code{piecewiseSurvivalTime}: A vector that specifies the starting
time of piecewise exponential survival time intervals.
Must start with 0, e.g., c(0, 6) breaks the time axis into 2 event
intervals: [0, 6) and [6, Inf).
\item \code{lambda}: A vector of hazard rates for the event. One for
each analysis time interval.
\item \code{loglik}: The sequence of the asymptotic limit of the
piecewise exponential log-likelihood for an increasing number
of change points.
}
}
\description{
Obtains the piecewise exponential distribution that
approximates a survival distribution.
}
\examples{

# Example 1: Piecewise exponential
pwexpcuts(ptpwexp, piecewiseSurvivalTime = c(0, 3.4, 5.5),
          lambda = c(0.0168, 0.0833, 0.0431), lowerBound = 0,
          lower.tail = FALSE)

# Example 2: Weibull
pwexpcuts(pweibull, shape = 1.37, scale = 1/0.818, lower.tail = FALSE)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
