% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{lrstat1}
\alias{lrstat1}
\title{Number of Subjects Having an Event and Log-Rank Statistic
for a hypothesized hazard ratio at a given calendar time}
\usage{
lrstat1(
  time = NA_real_,
  hazardRatioH0 = 1,
  allocationRatioPlanned = 1,
  accrualTime = 0L,
  accrualIntensity = NA_real_,
  piecewiseSurvivalTime = 0L,
  stratumFraction = 1L,
  lambda1 = NA_real_,
  lambda2 = NA_real_,
  gamma1 = 0L,
  gamma2 = 0L,
  accrualDuration = NA_real_,
  followupTime = NA_real_,
  fixedFollowup = 0L,
  rho1 = 0,
  rho2 = 0,
  numSubintervals = 300L,
  predictEventOnly = 0L
)
}
\arguments{
\item{time}{The calendar time at which to calculate the number
of events and the mean and variance of log-rank test score statistic.}

\item{hazardRatioH0}{Hazard ratio under the null hypothesis for the active
treatment versus control. Defaults to 1 for superiority test.}

\item{allocationRatioPlanned}{Allocation ratio for the active treatment
versus control. Defaults to 1 for equal randomization.}

\item{accrualTime}{A vector that specifies the starting time of
piecewise Poisson enrollment time intervals. Must start with 0, e.g.,
\code{c(0, 3)} breaks the time axis into 2 accrual intervals:
[0, 3) and [3, Inf).}

\item{accrualIntensity}{A vector of accrual intensities. One for
each accrual time interval.}

\item{piecewiseSurvivalTime}{A vector that specifies the starting time of
piecewise exponential survival time intervals. Must start with 0, e.g.,
\code{c(0, 6)} breaks the time axis into 2 event intervals:
[0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{stratumFraction}{A vector of stratum fractions that sum to 1.
Defaults to 1 for no stratification.}

\item{lambda1}{A vector of hazard rates for the event in each analysis
time interval by stratum for the active treatment group.}

\item{lambda2}{A vector of hazard rates for the event in each analysis
time interval by stratum for the control group.}

\item{gamma1}{The hazard rate for exponential dropout, a vector of hazard
rates for piecewise exponential dropout applicable for all strata, or a
vector of hazard rates for dropout in each analysis time interval
by stratum for the active treatment group.}

\item{gamma2}{The hazard rate for exponential dropout, a vector of hazard
rates for piecewise exponential dropout applicable for all strata, or a
vector of hazard rates for dropout in each analysis time interval
by stratum for the control group.}

\item{accrualDuration}{Duration of the enrollment period.}

\item{followupTime}{Follow-up time for the last enrolled subject.}

\item{fixedFollowup}{Whether a fixed follow-up design is used.
Defaults to 0 for variable follow-up.}

\item{rho1}{The first parameter of the Fleming-Harrington family of
weighted log-rank test. Defaults to 0 for conventional log-rank test.}

\item{rho2}{The second parameter of the Fleming-Harrington family of
weighted log-rank test. Defaults to 0 for conventional log-rank test.}

\item{numSubintervals}{Number of sub-intervals to approximate the mean
and variance of the weighted log-rank test score statistic.
Defaults to 300. Specify a larger number for better approximation.}

\item{predictEventOnly}{Whether to predict the number of events only.
Defaults to 0 for obtaining log-rank test score statistic mean
and variance.}
}
\value{
A data frame of the following variables if
\code{predictEventOnly = 1}:
\itemize{
\item \code{stratum}: The stratum number.
\item \code{time}: The analysis time since trial start.
\item \code{subjects}: The number of enrolled subjects.
\item \code{nevents}: The total number of events.
\item \code{nevents1}: The number of events in the active treatment group.
\item \code{nevents2}: The number of events in the control group.
\item \code{ndropouts}: The total number of dropouts.
\item \code{ndropouts1}: The number of dropouts in the active treatment
group.
\item \code{ndropouts2}: The number of dropouts in the control group.
\item \code{nfmax}: The total number of subjects reaching maximum follow-up.
\item \code{nfmax1}: The number of subjects reaching maximum follow-up in
the active treatment group.
\item \code{nfmax2}: The number of subjects reaching maximum follow-up in
the control group.
}

If \code{predictEventOnly = 0}, the following variables will also
be included:
\itemize{
\item \code{uscore}: The numerator of the weighted log-rank test statistic.
\item \code{vscore}: The variance of the weighted log-rank score statistic
with weight squared.
\item \code{iscore}: The Fisher information of the weighted log-rank score
statistic.
}
}
\description{
Obtains the number of subjects having an event in each
treatment group by stratum, the mean and variance of weighted log-rank
score statistic for a hypothesized hazard ratio at a given calendar time.
}
\examples{
# Piecewise accrual, piecewise exponential survivals, and 5\% dropout by
# the end of 1 year.

lrstat1(time = 22, hazardRatioH0 = 1,
        allocationRatioPlanned = 1,
        accrualTime = seq(0, 8),
        accrualIntensity = 26/9*seq(1, 9),
        piecewiseSurvivalTime = c(0, 6),
        lambda1 = c(0.0533, 0.0309),
        lambda2 = c(0.0533, 0.0533),
        gamma1 = -log(1-0.05)/12,
        gamma2 = -log(1-0.05)/12,
        accrualDuration = 22,
        followupTime = 18, fixedFollowup = FALSE)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
\keyword{internal}
