% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pevent}
\alias{pevent}
\title{Probability of having an event}
\usage{
pevent(
  time = NA_real_,
  piecewiseSurvivalTime = 0L,
  lambda = NA_real_,
  gamma = 0L
)
}
\arguments{
\item{time}{A vector of analysis times at which to calculate the
probability of having an event.}

\item{piecewiseSurvivalTime}{A vector that specifies the time intervals for
the piecewise exponential survival distribution, must start with 0, e.g.,
\code{c(0, 6)} breaks the time axis into 2 event intervals:
[0, 6) and [6, Inf).
Defaults to 0 for exponential distribution.}

\item{lambda}{A vector of hazard rates for the event, one for
each analysis time interval.}

\item{gamma}{The hazard rate for exponential dropout or a vector of hazard
rates for piecewise exponential dropout. Defaults to 0 for no dropout.}
}
\value{
A vector of probabilities of having an event at the specified
analysis times after enrollment for a patient in a treatment group with
specified piecewise exponential survival and dropout distributions.
}
\description{
Obtains the probability of having an event at given analysis
times.
}
\examples{
# Piecewise exponential survival with hazard 0.0533 in the first 6 months,
# and hazard 0.0309 thereafter, and 5\% dropout by the end of 1 year.

pevent(time = c(3, 9), piecewiseSurvivalTime = c(0, 6),
       lambda = c(0.0533, 0.0309), gamma = -log(1-0.05)/12)

}
\keyword{internal}
