% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{run.cache,function-method}
\alias{run.cache,function-method}
\title{Run function and save cache}
\usage{
\S4method{run.cache}{`function`}(
  fun,
  ...,
  seed = NULL,
  base.dir = NULL,
  cache.prefix = "generic_cache",
  cache.digest = list(),
  show.message = NULL,
  force.recalc = FALSE,
  add.to.hash = NULL
)
}
\arguments{
\item{fun}{function call name}

\item{...}{parameters for function call}

\item{seed}{when function call is random, this allows to set seed beforehand}

\item{base.dir}{directory where data is stored}

\item{cache.prefix}{prefix for file name to be generated from
parameters (...)}

\item{cache.digest}{cache of the digest for one or more of the parameters}

\item{show.message}{show message that data is being retrieved from cache}

\item{force.recalc}{force the recalculation of the values}

\item{add.to.hash}{something to add to the filename generation}
}
\value{
the result of fun(...)
}
\description{
Run function and save cache
}
\examples{
# [optional] save cache in a temporary directory
# otherwise it writes to the current directory
# to folder named run-cache
base.dir(tempdir())
#
run.cache(c, 1, 2, 3, 4)
#
# next three should use the same cache
#  note, the middle call should be a little faster as digest is not
#  calculated
#   for the first argument
run.cache(c, 1, 2, 3, 4)
run.cache(c, 1, 2, 3, 4, cache.digest = list(digest.cache(1)))
run.cache(c, a=1, 2, c= 3, 4)
}
