% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/loo_and_waic_diff.R
\name{loo_and_waic_diff}
\alias{loo_and_waic_diff}
\title{Model comparison}
\usage{
loo_and_waic_diff(loo1, loo2)
}
\arguments{
\item{loo1,loo2}{lists (of class \code{'loo'}) returned by
\code{\link{loo_and_waic}}.}
}
\value{
a named list with class \code{'compare.loo'}.
}
\description{
Compare two fitted models on LOO and WAIC
}
\details{
When comparing two fitted models, we can estimate the difference in
  their expected predictive accuracy by the difference in \code{elpd_waic} or
  \code{elpd_loo} (multiplied by -2, if desired, to be on the deviance
  scale). To compute the standard error of this difference we can use a
  paired estimate to take advantage of the fact that the same set of \eqn{N}
  data points is being used to fit both models. We would think that these
  calculations would be most useful when \eqn{N} is large, because then
  non-normality of the distribution is not such an issue when estimating the
  uncertainty of these sums. In any case, we suspect that these standard
  errors, for all their flaws, should give a better sense of uncertainty than
  what is obtained using the current standard approach of comparing
  differences of deviances to a Chi-squared distribution, a practice derived
  for Gaussian linear models or asymptotically and which only applies to
  nested models in any case.
}
\examples{
\dontrun{
loo1 <- loo_and_waic(log_lik1)
loo2 <- loo_and_waic(log_lik2)
diff <- loo_and_waic_diff(loo1, loo2)
print(diff, digits = 1)
}
}
\seealso{
\code{\link{loo_and_waic}}, \code{\link{print.compare.loo}}
}

