% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gofit.R
\name{gofit.lolog}
\alias{gofit.lolog}
\title{Goodness of Fit Diagnostics for a LOLOG fit}
\usage{
\method{gofit}{lolog}(object, formula, nsim = 100, ...)
}
\arguments{
\item{object}{the object to evaluate}

\item{formula}{A formula specifying the statistics on which to evaluate the fit}

\item{nsim}{The number of simulated statistics}

\item{...}{additional parameters}
}
\description{
Goodness of Fit Diagnostics for a LOLOG fit
}
\examples{
library(network)
data(ukFaculty)

# Delete vertices missing group
delete.vertices(ukFaculty, which(is.na(ukFaculty \%v\% "Group")))

# A dyad independent model
fitind <- lolog(ukFaculty ~ edges() + nodeMatch("GroupC") + nodeCov("GroupC"))
summary(fitind)

# Check gof on degree distribution (bad!)
gind <- gofit(fitind, ukFaculty ~ degree(0:50))
gind
plot(gind)

#check gof on esp distribution (bad!)
gind <- gofit(fitind, ukFaculty ~ esp(0:25))
gind
plot(gind)

\dontrun{

#include triangles and 2-stars (in and out)
fitdep <- lolog(ukFaculty ~ edges() + nodeMatch("GroupC") + nodeCov("GroupC") + 
                triangles + star(2, direction="in") + star(2, direction="out"), nsamp=1500)
summary(fitdep)

# Check gof on (in + out) degree distribution (good!)
gdep <- gofit(fitdep, ukFaculty ~ degree(0:50))
gdep
plot(gdep)

#check gof on esp distribution (good!)
gdep <- gofit(fitdep, ukFaculty ~ esp(0:25))
gdep
plot(gdep)

}


}
