% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wtp.R
\name{wtp}
\alias{wtp}
\title{Get WTP estimates a preference space model}
\usage{
wtp(object, scalePar)
}
\arguments{
\item{object}{is an object of class \code{logitr} (a model estimated using
the 'logitr()` function).}

\item{scalePar}{The name of the column that identifies the scale variable,
which is typically "price" for WTP space models, but could be any
continuous variable, such as "time".}
}
\value{
A data frame of the WTP estimates.
}
\description{
Returns the computed WTP from a preference space model.
}
\details{
Willingness to pay is computed by dividing the estimated parameters of a
utility model in the "preference" space by the scale parameter, which is
should be price to obtain WTP estimates. Uncertainty is handled via
simulation.
}
\examples{
library(logitr)

# Estimate a preference space model
mnl_pref <- logitr(
  data    = yogurt,
  outcome = "choice",
  obsID   = "obsID",
  pars    = c("price", "feat", "brand")
)

# Compute the WTP implied from the preference space model
wtp(mnl_pref, scalePar = "price")
}
\keyword{logitr}
\keyword{wtp}
