% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output-fxns.R
\name{predict.litfit}
\alias{predict.litfit}
\title{Predict method for litfit objects}
\usage{
\method{predict}{litfit}(object,newdata=NULL,...)
}
\arguments{
\item{object}{litfit object}

\item{newdata}{optional vector of new Time points at which to predict mass remaining. If not specified, Time points from the original fit are used.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
predicted values from a litfit object
}
\description{
Generated predicted values for (new) time points from a litfit model fit
}
\details{
to do
}
\examples{
fit<-fit_litter(time=c(0,1,2,3,4,5,6),mass.remaining=c(1,0.9,1.01,0.4,0.6,0.2,0.01),
'neg.exp',iters=250)
predict(fit, newdata=1:10)

}
\seealso{
\code{\link{fit_litter}}
}
\author{
Will Cornwell

James Weedon
}
