% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshape.R
\name{set_as_rows}
\alias{set_as_rows}
\alias{set_as_cols}
\title{Reshape an array to send a dimension forward or back}
\usage{
set_as_rows(X, which_dim)

set_as_cols(X, which_dim)
}
\arguments{
\item{X}{an array}

\item{which_dim}{scalar integer or string, which dim to bring forward.
Negative numbers count from the back

This is a powered by \code{base::aperm()}.}
}
\value{
a reshaped array
}
\description{
Reshape an array to send a dimension forward or back
}
\examples{
x <- array(1:24, 2:4)
y <- set_as_rows(x, 3)

for (i in seq_along_dim(x, 3))
  stopifnot( identical(x[,,i], y[i,,]) )
}
\seealso{
\code{base::aperm()} \code{set_dim()} \code{keras::array_reshape()}
}
