% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixToCorCouples.R
\name{matrixToCorCouples}
\alias{matrixToCorCouples}
\title{Matrix to couples}
\usage{
matrixToCorCouples(matrix, coefName = "Coef.", sortByDescAbs = F)
}
\arguments{
\item{matrix}{a dataframe corresponding to a matrix of correlation.}

\item{coefName}{a string: the name of the coefficient the values of the matrix represent.}

\item{sortByDescAbs}{a boolean to decide if to sort by descending absolute value of the coefficient.}
}
\value{
a dataframe corresponding to all correlation couples from the matrix.
}
\description{
Transform a correlation matrix into a correlation couples dataframe
}
\examples{
# calculate a correlation dataframe
data(iris)
corDF<-multiBivariateCorrelation(dataset = iris)
corMatrix<-corCouplesToMatrix(x1_x2_val = corDF[,c('X1','X2',"pearson")])
print(corMatrix)
corCouples<-matrixToCorCouples(matrix = corMatrix,coefName="pearson")
print(corCouples)

}
