% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leaflet.R
\name{update_leaflet_selection}
\alias{update_leaflet_selection}
\title{Update Leaflet Map Selection}
\usage{
update_leaflet_selection(component_id, selected_id, session, components)
}
\arguments{
\item{component_id}{Character string. The ID of the Leaflet map component to update.}

\item{selected_id}{Character string or NULL. The ID of the selected item. If NULL,
indicates deselection.}

\item{session}{'shiny' session object. The current 'shiny' session.}

\item{components}{List. A named list containing component information, where each
element contains component configuration including data_reactive, shared_id_column,
and config settings.}
}
\value{
NULL (invisibly). The function is called for its side effects on the Leaflet map.
}
\description{
\code{update_leaflet_selection} updates a Leaflet map component to reflect a new selection state. This function
handles both selection and deselection events, applying either custom user-defined
click handlers or default behaviors.
}
\details{
The function performs the following operations:
\itemize{
\item Validates that the leaflet package is available
\item Checks that required columns (shared_id_column, lng_col, lat_col) exist in the data
\item Clears existing popups on the map
\item For selections: finds the selected data row and applies either custom click handler or default behavior
\item For deselections: delegates to custom handler or performs default cleanup
}

Required columns in the component data:
\itemize{
\item \code{shared_id_column}: Column containing unique identifiers for map features
\item \code{lng_col}: Column containing longitude coordinates
\item \code{lat_col}: Column containing latitude coordinates
}
}
\note{
If the leaflet package is not available, the function returns early without error.
Missing required columns will generate a warning and cause early return.
}
