% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear.tools.R
\name{check_vec_meaningful}
\alias{check_vec_meaningful}
\title{check x is a meaningful vector}
\usage{
check_vec_meaningful(x)
}
\arguments{
\item{x}{any object}
}
\value{
If it is a meaningful vector, the return \code{TRUE}, otherwise \code{FALSE}
}
\description{
check x is a meaningful vector
}
\details{
we define "a meaningful vector" as
1. cannot be a 'list'
2. with positive length,
3. with valid common one-dimensional slicing method, like x[1] etc, # so factor, character, numeric will pass the check
4. not all elements being NA.
}
\examples{

check_vec_meaningful(c(NA,NA)) # NOT PASS

tryCatch(check_vec_meaningful(x=list(NA,NaN)),
         error = function(err){
           print(err)
           }
         )# NOT PASS

check_vec_meaningful(c(NA,1)) # PASS
check_vec_meaningful(c(NULL,1)) # PASS
check_vec_meaningful(factor(c(NA,1,1))) # PASS
check_vec_meaningful(1) # PASS
check_vec_meaningful('1') # PASS

}
\keyword{internal}

