% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lilikoi.KEGGplot.R
\name{lilikoi.KEGGplot}
\alias{lilikoi.KEGGplot}
\title{lilikoi.KEGGplot}
\usage{
lilikoi.KEGGplot(
  metamat,
  sampleinfo,
  grouporder,
  pathid = "00250",
  specie = "hsa",
  filesuffix = "GSE16873",
  Metabolite_pathway_table = Metabolite_pathway_table
)
}
\arguments{
\item{metamat}{metabolite expression data matrix}

\item{sampleinfo}{is a vector of sample group, with element names as sample IDs.}

\item{grouporder}{grouporder is a vector with 2 elements,
the first element is the reference group name, like 'Normal', the second one is the experimental group name like 'Cancer'.}

\item{pathid}{character variable, Pathway ID, usually 5 digits.}

\item{specie}{character, scientific name of the targeted species.}

\item{filesuffix}{output file suffix}

\item{Metabolite_pathway_table}{Metabolites mapping table}
}
\value{
Pathview visualization output
}
\description{
Visualizes selected pathways based on their metabolites expression data.
}
\examples{
\donttest{
dt = lilikoi.Loaddata(file=system.file("extdata","plasma_breast_cancer.csv", package = "lilikoi"))
Metadata <- dt$Metadata
dataSet <- dt$dataSet
convertResults=lilikoi.MetaTOpathway('name')
Metabolite_pathway_table = convertResults$table

data_dir=system.file("extdata", "plasma_breast_cancer.csv", package = "lilikoi")
plasma_data <- read.csv(data_dir, check.names=FALSE, row.names=1, stringsAsFactors = FALSE)
sampleinfo <- plasma_data$Label
names(sampleinfo) <- row.names(plasma_data)

metamat <- t(t(plasma_data[-1]))
metamat <- log2(metamat)
grouporder <- c('Normal', 'Cancer')
# make sure install pathview package first before running the following code.
library(pathview)
data("bods", package = "pathview")
options(bitmapType='cairo')
 lilikoi.KEGGplot(metamat = metamat, sampleinfo = sampleinfo, grouporder = grouporder,
  pathid = '00250', specie = 'hsa',filesuffix = 'GSE16873',
  Metabolite_pathway_table = Metabolite_pathway_table)
}
}
