% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L_1way_cat.R
\name{L_1way_cat}
\alias{L_1way_cat}
\title{Likelihood Support for One-way Categorical Data}
\usage{
L_1way_cat(obs, exp.p=NULL, L.int=2, alpha=0.05, toler=0.0001, verb=TRUE)
}
\arguments{
\item{obs}{a vector containing the number of counts in each category.}

\item{exp.p}{a vector containing expected probabilities. If NULL then this is 1/#cats.}

\item{L.int}{likelihood interval given as support values, e.g. 2 or 3, default = 2.}

\item{alpha}{the significance level used, 1 - alpha interval calculated, default = 0.05.}

\item{toler}{the desired accuracy using optimise, default = 0.0001.}

\item{verb}{show output, default = TRUE.}
}
\value{
$S.val - support for one-way observed versus expected.

$uncorrected.sup - uncorrected support.

$df - degrees of freedom for table.

$observed - observed counts.

$exp.p - expected probabilities.

$too.good - support for the variance of counts being more different than expected.

$chi.sq - chi-squared value.

$p.value - p value for chi-squared.

$LR.test = the likelihood ratio test statistic.

$lrt.p = the p value for the likelihood ratio test statistic

Additional outputs for binomial:

$prob.val - MLE probability from data.

$succ.fail - number of successes and failures.

$like.int - likelihood interval.

$like.int.spec - specified likelihood interval in units of support.

$conf.int - likelihood-based confidence interval.

$alpha.spec - specified alpha for confidence interval.

$err.acc - error accuracy for optimize function.
}
\description{
This function calculates the support for one-way categorical data (multinomial), also
gives chi-squared and likelihood ratio test (G) statistics. If there are only 2
categories then binomial information
is given too with likelihood interval, including the likelihood-based \% confidence
interval. Support for the variance being more different than expected (Edwards p 187,
Cahusac p 158) is also calculated.
It uses the optimize function to locate desired limits for both intervals.
}
\examples{
# example for binomial, p 123
obs <- c(6,4)
L_1way_cat(obs, L.int=3)

# example for multinomial, p 134
obs <- c(60,40,100)
exp <- c(0.25,0.25,0.5)
L_1way_cat(obs, exp.p=exp)

}
\references{
Aitkin, M. et al (1989) Statistical Modelling in GLIM, Clarendon Press, ISBN : 978-0198522041

Cahusac, P.M.B. (2020) Evidence-Based Statistics, Wiley, ISBN : 978-1119549802

Royall, R. M. (1997). Statistical evidence: A likelihood paradigm. London: Chapman & Hall, ISBN : 978-0412044113

Edwards, A.W.F. (1992) Likelihood, Johns Hopkins Press, ISBN : 978-0801844430
}
\keyword{Likelihood-based;}
\keyword{binomial;}
\keyword{confidence}
\keyword{interval}
