# liftr 0.5 (2017-04-11)

## New Features

- Added RStudio addins as shortcuts to containerize and render R Markdown documents.
- Added new argument `cache` in `render_docker()` to improve rendering speed significantly by caching Docker image layers [[#18](https://github.com/road2stat/liftr/issues/18)].
- Added new argument `purge_info` to `render_docker()`. This argument controls whether to output the Docker image and container name into an YAML file for purging purposes later.
- Separate the creation and removal of Docker containers and images: removed the old argument `reset` in `render_docker()`; added `purge_container()` and `purge_image()` for cleaning up.
- The `ghpkg` field is now deprecated. The new `remotes` field supports [devtools remote package name format](https://github.com/hadley/devtools/blob/master/vignettes/dependencies.Rmd). Now packages can be installed from GitHub, Bitbucket, Git/SVN servers, URLs, etc.
- Added new metadata field `include` for including any custom Dockerfile snippets into the final Dockerfile. This also fixes [#21](https://github.com/road2stat/liftr/issues/21).

## Improvements

- Renamed `drender()` to `render_docker()`. `drender()` is now deprecated.
- Better naming scheme for `liftr` metadata fields.
- Tidy up the output Dockerfile by `lift()`.
- Added two new examples in `inst/examples/`: explore tidyverse and Bioconductor RNA-Seq workflow.
- New website (https://liftr.me) generated by pkgdown, with a full set of function documentation and vignettes available.
- Added Appveyor support for continuous integration under Windows.
- Removed Rabix support temporarily to embrace its new version in the future.
- Added a new demo video.

## Bug Fixes

- Removed `-t` and `-i` from `docker run` to fix [#17](https://github.com/road2stat/liftr/issues/17).

# liftr 0.4 (2016-08-05)

## Improvements

- Maintainer email updates.

# liftr 0.3 (2015-10-10)

## New Features

- Support specifying CRAN package version precisely.

## Improvements

- Modified examples in documentation to comply with the lastest CRAN Repository Policy.
- Installing packages with https.

# liftr 0.2 (2015-07-30)

## Bug Fixes

- [Correctly rendered](https://github.com/rstudio/rmarkdown/issues/470) the vignette with Pandoc 1.15.0.6.

## New Features

- Added new R Markdown header option `pandoc` to control Pandoc installation. Automatically set this to `false` for `rocker/rstudio` and `bioconductor/...` images. This solves [#12](https://github.com/road2stat/liftr/issues/12).

# liftr 0.1 (2015-07-10)

## New Features

- Initial version of liftr. This version implemented two functions `lift()` and `drender()`. They provide basic support for dockerizing R Markdown documents, with support for running Rabix workflows/tools before rendering R Markdown documents in Docker containers.
