% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warning.R
\name{last_warnings}
\alias{last_warnings}
\alias{last_warning}
\title{Display last deprecation warnings}
\usage{
last_warnings()

last_warning()
}
\description{
Call these helpers to see the last deprecation warnings along with
their backtrace:
\itemize{
\item \code{last_warnings()} returns a list of all warnings that occurred
during the last top-level R command.
\item \code{last_warning()} returns only the last.
}

If you call these in the console, these warnings are printed with a
backtrace. Use \code{print(last_warnings(), simplify = level)} to
control the verbosity of the backtrace. The \code{simplify} argument
supports one of \code{"branch"} (the default), \code{"collapse"}, and
\code{"none"} (in increasing order of verbosity).
}
\examples{
# These examples are not run because `last_warnings()` does not
# work well within knitr and pkgdown
\dontrun{

f <- function() invisible(g())
g <- function() list(h(), i())
h <- function() deprecate_warn("1.0.0", "this()")
i <- function() deprecate_warn("1.0.0", "that()")
f()

# Print all the warnings that occurred during the last command:
last_warnings()

# Print only the last one:
last_warning()


# By default, the backtraces are printed in their simplified form.
# Use `simplify` to control the verbosity:
print(last_warnings(), simplify = "none")

}
}
