% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coregistration.R
\name{rasters2Cor}
\alias{rasters2Cor}
\title{Correlation between two rasters}
\usage{
rasters2Cor(raster_b, raster_s, mask = NULL, small.SC = TRUE)
}
\arguments{
\item{raster_b}{SpatRaster. raster to correlate with largest extent}

\item{raster_s}{SpatRaster. raster to correlate with smallest extent}

\item{mask}{SpatRaster. mask of area to correlate}

\item{small.SC}{boolean. is the small raster already standardized and 
centered ?}
}
\value{
A numeric
}
\description{
computes correlation between two rasters, based on the extent of the smallest 
one.
}
\examples{
# create raster
r_b <- terra::rast(xmin = 0, xmax = 40, ymin =0 , ymax = 40,
resolution = 1, crs = NA)
xy <- terra::xyFromCell(r_b, 1:(nrow(r_b) * ncol(r_b)))

# add Gaussian surface and noise
z <- 3 * exp(-((xy[, 1] - 20)^2 + (xy[, 2] - 20)^2 / 2) / 6)
r_b <- terra::rast(cbind(xy, z), type = "xyz")

# create circular mask of radius 5
z_mask <- (xy[, 1] - 20)^2 + (xy[, 2] - 20)^2 < 5^2
r_mask <- terra::rast(cbind(xy, z_mask), type = "xyz")

# create small raster of size 20
r_s <- terra::crop(r_b, terra::ext(c(10, 30, 10, 30)))

# add noise to small raster
terra::values(r_s) <- terra::values(r_s) + rnorm(ncol(r_s) * nrow(r_s), 0, 0.5)
r_mask <- terra::crop(r_mask, terra::ext(c(10, 30, 10, 30)))

# compute correlation on masked area where signal to noise ratio is lower
rasters2Cor(r_b, r_s, r_mask, small.SC = FALSE)

# compute correlation for whole small raster
rasters2Cor(r_b, r_s, small.SC = FALSE)

# display large raster
terra::plot(r_b, main = "Large raster")
# display small raster
terra::plot(r_s, main = "Small raster")
# display mask
terra::plot(r_mask, main = "Computation mask")
}
\seealso{
\code{\link{rasters_moving_cor}} to compute correlation between rasters
for different translations
}
