% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optical_metrics.R
\name{add_vegetation_indices}
\alias{add_vegetation_indices}
\title{Add vegetation indices on a IRC image}
\usage{
add_vegetation_indices(r, all = FALSE)
}
\arguments{
\item{r}{raster or data.frame. Should contain bands or columns with
names nir, r, g}

\item{all}{boolean. indicates whether all indices should be computed;
default:FALSE, only grvi, sr and ndvi are calculated}
}
\value{
a raster or data.frame with added bands or columns
}
\description{
Computes vegetations indices from the Red, Green and Infra-Red bands of an IRC
image and adds them as additionnal bands or columns. Indices are listed on
\url{https://www.l3harrisgeospatial.com/docs/broadbandgreenness.html}
}
\examples{
df <- data.frame(nir = c(110, 150, 20), r = c(25, 50, 30), g = c(10, 60, 10))
add_vegetation_indices(df, all = TRUE)
}
