% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_poi.R
\name{filters}
\alias{filters}
\alias{filter_first}
\alias{filter_firstlast}
\alias{filter_firstofmany}
\alias{filter_ground}
\alias{filter_last}
\alias{filter_nth}
\alias{filter_single}
\title{Predefined point of interest filters}
\usage{
filter_first(las)

filter_firstlast(las)

filter_firstofmany(las)

filter_ground(las)

filter_last(las)

filter_nth(las, n)

filter_single(las)
}
\arguments{
\item{las}{An object of class \code{\link[=LAS-class]{LAS}}}

\item{n}{the position in the return sequence}
}
\value{
An object of class \code{\link[=LAS-class]{LAS}}
}
\description{
Select only some returns
}
\details{
\itemize{
\item{\code{filter_first} Select only the first returns.}
\item{\code{filter_firstlast} Select only the first and last returns.}
\item{\code{filter_ground} Select only the returns classified as ground according to LAS specification.}
\item{\code{filter_last} Select only the last returns i.e. the last returns and the single returns.}
\item{\code{filter_nth} Select the returns from their position in the return sequence.}
\item{\code{filter_firstofmany} Select only the first returns from pulses which returned multiple points.}
\item{\code{filter_single} Select only the returns that return only one point.}
}
}
\examples{
LASfile <- system.file("extdata", "Megaplot.laz", package="lidR")
lidar = readLAS(LASfile)

firstReturns  = filter_first(lidar)
groundReturns = filter_ground(lidar)
}
\seealso{
Other filters: 
\code{\link{filter_duplicates}()},
\code{\link{filter_poi}()},
\code{\link{filter_surfacepoints}()}

Other filters: 
\code{\link{filter_duplicates}()},
\code{\link{filter_poi}()},
\code{\link{filter_surfacepoints}()}

Other filters: 
\code{\link{filter_duplicates}()},
\code{\link{filter_poi}()},
\code{\link{filter_surfacepoints}()}

Other filters: 
\code{\link{filter_duplicates}()},
\code{\link{filter_poi}()},
\code{\link{filter_surfacepoints}()}

Other filters: 
\code{\link{filter_duplicates}()},
\code{\link{filter_poi}()},
\code{\link{filter_surfacepoints}()}

Other filters: 
\code{\link{filter_duplicates}()},
\code{\link{filter_poi}()},
\code{\link{filter_surfacepoints}()}

Other filters: 
\code{\link{filter_duplicates}()},
\code{\link{filter_poi}()},
\code{\link{filter_surfacepoints}()}

Other filters: 
\code{\link{filter_duplicates}()},
\code{\link{filter_poi}()},
\code{\link{filter_surfacepoints}()}
}
\concept{filters}
