/* libsoc - Library to handle standardised output files
 * Copyright (C) 2015 Rikard Nordgren
 * 
 * This file was autogenerated and should not be edited
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * 
 * his library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, see <http://www.gnu.org/licenses/>.
 */
#ifndef _SO_PRIVATE_SIMULATIONBLOCK_H
#define _SO_PRIVATE_SIMULATIONBLOCK_H

#include <libxml/xmlwriter.h>

#include <so/private/SimulationSubType.h>
#include <so/private/ExternalFile.h>

struct so_SimulationBlock {
	int *replicate;
	int replicate_number;
	so_SimulationSubType **SimulatedProfiles;
	so_SimulationSubType **IndivParameters;
	so_SimulationSubType **RandomEffects;
	so_SimulationSubType **Covariates;
	so_SimulationSubType **Regressors;
	so_SimulationSubType **PopulationParameters;
	so_SimulationSubType **Dosing;
	so_ExternalFile *RawResultsFile;
	int num_SimulatedProfiles;
	int num_IndivParameters;
	int num_RandomEffects;
	int num_Covariates;
	int num_Regressors;
	int num_PopulationParameters;
	int num_Dosing;
	int in_SimulatedProfiles;
	int in_IndivParameters;
	int in_RandomEffects;
	int in_Covariates;
	int in_Regressors;
	int in_PopulationParameters;
	int in_Dosing;
	int in_RawResultsFile;
	int reference_count;
};

int so_SimulationBlock_start_element(so_SimulationBlock *self, const char *localname, int nb_attributes, const char **attributes);
void so_SimulationBlock_end_element(so_SimulationBlock *self, const char *localname);
int so_SimulationBlock_characters(so_SimulationBlock *self, const char *ch, int len);
int so_SimulationBlock_xml(so_SimulationBlock *self, xmlTextWriterPtr writer);
int so_SimulationBlock_init_attributes(so_SimulationBlock *self, int nb_attributes, const char **attributes);

#endif
