# libsoc - Library to handle standardised output files
# Copyright (C) 2015 Rikard Nordgren
# 
# This file was autogenerated and should not be edited
# 
# This library is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
# 
# his library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Lesser General Public License for more details.
# 
# You should have received a copy of the GNU Lesser General Public
# License along with this library; if not, see <http://www.gnu.org/licenses/>.

so_ExternalFile_new <- function() {
	obj = .Call("r_so_ExternalFile_new")
}

so_ExternalFile_copy <- function(self) {
	.Call("r_so_ExternalFile_copy", self)
}

so_ExternalFile_free <- function(self) {
	.Call("r_so_ExternalFile_free", self)
}

so_ExternalFile_ref <- function(self) {
	.Call("r_so_ExternalFile_ref", self)
}

so_ExternalFile_unref <- function(self) {
	.Call("r_so_ExternalFile_unref", self)
}

so_ExternalFile_get_oid <- function(self) {
	.Call("r_so_ExternalFile_get_oid", self)
}

so_ExternalFile_set_oid <- function(self, value) {
	.Call("r_so_ExternalFile_set_oid", self, value)
}

so_ExternalFile_get_Description <- function(self) {
	.Call("r_so_ExternalFile_get_Description", self)
}

so_ExternalFile_set_Description <- function(self, value) {
	.Call("r_so_ExternalFile_set_Description", self, value)
}

so_ExternalFile_get_path <- function(self) {
	.Call("r_so_ExternalFile_get_path", self)
}

so_ExternalFile_set_path <- function(self, value) {
	.Call("r_so_ExternalFile_set_path", self, value)
}

so_ExternalFile_get_format <- function(self) {
	.Call("r_so_ExternalFile_get_format", self)
}

so_ExternalFile_set_format <- function(self, value) {
	.Call("r_so_ExternalFile_set_format", self, value)
}

so_ExternalFile_get_delimiter <- function(self) {
	.Call("r_so_ExternalFile_get_delimiter", self)
}

so_ExternalFile_set_delimiter <- function(self, value) {
	.Call("r_so_ExternalFile_set_delimiter", self, value)
}

so_ExternalFile_get_MissingData <- function(self, number) {
	.Call("r_so_ExternalFile_get_MissingData", self, number)
}

so_ExternalFile_get_number_of_MissingData <- function(self) {
	.Call("r_so_ExternalFile_get_number_of_MissingData", self)
}
so_ExternalFile_add_MissingData <- function(self, value) {
	.Call("r_so_ExternalFile_add_MissingData", self, value)
}
so_ExternalFile_remove_MissingData <- function(self, index) {
	.Call("r_so_ExternalFile_remove_MissingData", self, index)
}

so_ExternalFile_create_MissingData <- function(self) {
	.Call("r_so_ExternalFile_create_MissingData", self)
}

oid_acc <- function(value)
{
	if (!isnull(.self$.cobj)) {
		if (missing(value)) {
			so_ExternalFile_get_oid(.self$.cobj)
		} else {
			stopifnot(is.character(value), length(value) == 1)
			so_ExternalFile_set_oid(.self$.cobj, value)
		}
	}
}

Description_acc <- function(value)
{
	if (!isnull(.self$.cobj)) {
		if (missing(value)) {
			so_ExternalFile_get_Description(.self$.cobj)
		} else {
			if (!is(value, "character")) {
				stop("object must be of type 'character'")
			}
			so_ExternalFile_set_Description(.self$.cobj, value)
		}
	}
}

path_acc <- function(value)
{
	if (!isnull(.self$.cobj)) {
		if (missing(value)) {
			so_ExternalFile_get_path(.self$.cobj)
		} else {
			if (!is(value, "character")) {
				stop("object must be of type 'character'")
			}
			so_ExternalFile_set_path(.self$.cobj, value)
		}
	}
}

format_acc <- function(value)
{
	if (!isnull(.self$.cobj)) {
		if (missing(value)) {
			so_ExternalFile_get_format(.self$.cobj)
		} else {
			if (!is(value, "character")) {
				stop("object must be of type 'character'")
			}
			so_ExternalFile_set_format(.self$.cobj, value)
		}
	}
}

delimiter_acc <- function(value)
{
	if (!isnull(.self$.cobj)) {
		if (missing(value)) {
			so_ExternalFile_get_delimiter(.self$.cobj)
		} else {
			if (!is(value, "character")) {
				stop("object must be of type 'character'")
			}
			so_ExternalFile_set_delimiter(.self$.cobj, value)
		}
	}
}

MissingData_acc <- function(value)
{
	if (!isnull(.self$.cobj)) {
		if (missing(value)) {
			n = so_ExternalFile_get_number_of_MissingData(.self$.cobj)
			if (n > 0) {
				a = list()
				for (i in seq.int(1, n)) {
					child = so_ExternalFile_get_MissingData(.self$.cobj, i - 1L)
					a[[i]] = so_MissingData$new(cobj=child)
					so_MissingData_ref(child)
				}
				return(a)
			}
		} else {
		}
	}
}

so_ExternalFile = setRefClass("so_ExternalFile",
	fields=list(
		oid = oid_acc,
		Description = Description_acc,
		path = path_acc,
		format = format_acc,
		delimiter = delimiter_acc,
		MissingData = MissingData_acc,
		.cobj = "externalptr"
	),
	methods=list(
		copy = function() {
			copy = so_ExternalFile_copy(.self$.cobj)
			so_ExternalFile$new(cobj=copy)
		},
		initialize = function(cobj) {
			if (missing(cobj)) {
				.cobj <<- so_ExternalFile_new()
			} else {
				.cobj <<- cobj
			}
		},
		finalize = function() {
			so_ExternalFile_unref(.self$.cobj)
		},
		add_MissingData = function(value) {
			so_ExternalFile_add_MissingData(.self$.cobj, value$.cobj)
			invisible(so_MissingData_ref(value$.cobj))
		},
		remove_MissingData = function(value, index) {
			invisible(so_ExternalFile_remove_MissingData(.self$.cobj, index))
		}
	)
)
