% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bibcodes.R
\name{convert_to_isbn_13}
\alias{convert_to_isbn_13}
\title{Convert ISBN 10 to ISBN 13}
\usage{
convert_to_isbn_13(x, skip.validity.check = FALSE, errors.as.nas = FALSE)
}
\arguments{
\item{x}{A string of 10 digits or 9 digits with terminal "X"}

\item{skip.validity.check}{Skip the checking for whether the ISBN 10 is valid
(default is \code{FALSE})}

\item{errors.as.nas}{return NA if error instead of throwing error
(default is \code{FALSE})}
}
\value{
Returns ISBN 13 as a string
}
\description{
Takes a string representation of an ISBN 10 and converts it to an ISBN 13.
}
\examples{

convert_to_isbn_13("012491540X")                # 9780124915404

# vectorized
convert_to_isbn_13(c("012491540X", "9004037810"))
# "9780124915404" "9789004037816"

}
