% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa.R, R/methods-lgpmodel.R
\docType{class}
\name{lgpmodel-class}
\alias{lgpmodel-class}
\alias{lgpmodel}
\alias{show,lgpmodel-method}
\alias{parameter_info,lgpmodel-method}
\alias{component_info,lgpmodel-method}
\alias{covariate_info,lgpmodel-method}
\alias{component_names,lgpmodel-method}
\alias{is_f_sampled,lgpmodel-method}
\title{An S4 class to represent an additive GP model}
\usage{
\S4method{show}{lgpmodel}(object)

\S4method{parameter_info}{lgpmodel}(object, digits = 3)

\S4method{component_info}{lgpmodel}(object)

\S4method{covariate_info}{lgpmodel}(object)

\S4method{component_names}{lgpmodel}(object)

\S4method{is_f_sampled}{lgpmodel}(object)
}
\arguments{
\item{object}{The object for which to apply a class method.}

\item{digits}{number of digits to show for floating point numbers}
}
\description{
An S4 class to represent an additive GP model
}
\section{Methods (by generic)}{
\itemize{
\item \code{show}: Print information and summary about the object.
Returns \code{object} invisibly.

\item \code{parameter_info}: Get a parameter summary (bounds and
priors). Returns a \code{data.frame}.

\item \code{component_info}: Get a data frame with information about each model
component.

\item \code{covariate_info}: Get covariate information.

\item \code{component_names}: Get names of model components.

\item \code{is_f_sampled}: Determine if inference of the model requires sampling
the latent signal \code{f} (and its components).
}}

\section{Slots}{

\describe{
\item{\code{formula}}{An object of class \linkS4class{lgpformula}}

\item{\code{data}}{The original unmodified data.}

\item{\code{stan_input}}{The data to be given as input to \code{rstan::sampling}}

\item{\code{var_names}}{List of variable names grouped by type.}

\item{\code{var_scalings}}{A named list with fields
\itemize{
  \item \code{y} - Response variable normalization function and its
  inverse operation. Must be an \linkS4class{lgpscaling} object.
  \item \code{x_cont} - Continuous covariate normalization functions and
  their inverse operations. Must be a named list with each element is an
  \linkS4class{lgpscaling} object.
}}

\item{\code{var_info}}{A named list with fields
\itemize{
  \item \code{x_cat_levels} - Names of the levels of categorical covariates
  before converting from factor to numeric.
}}

\item{\code{info}}{Other info in text format.}

\item{\code{sample_f}}{Whether the signal \code{f} is sampled or marginalized.}

\item{\code{full_prior}}{Complete prior information.}
}}

