## ----include=FALSE----------------------------------------------------------------------------------------------------
knitr::opts_chunk$set(fig.width=5, fig.height=4)

## ----include=FALSE----------------------------------------------------------------------------------------------------
suppressPackageStartupMessages(library("lessR"))

## ---------------------------------------------------------------------------------------------------------------------
d <- Read("Employee")

## ---------------------------------------------------------------------------------------------------------------------
Plot(Salary, run=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
Plot(Salary, run=TRUE, size=0, area_fill="on", center_line="off")

## ---------------------------------------------------------------------------------------------------------------------
d <- Read("StockPrice")
d[1:5,]

## ---------------------------------------------------------------------------------------------------------------------
Plot(Month, Price, filter=(Company=="Apple"))

## ---------------------------------------------------------------------------------------------------------------------
Plot(Month, Price, filter=(Company=="Apple"), area_fill="on")

## ----fig.width=5------------------------------------------------------------------------------------------------------
Plot(Month, Price, by=Company)

## ----fig.width=5------------------------------------------------------------------------------------------------------
Plot(Month, Price, by=Company, stack=TRUE)

## ----fig.width=5------------------------------------------------------------------------------------------------------
Plot(Month, Price, by1=Company)

## ----fig.width=5------------------------------------------------------------------------------------------------------
style(sub_theme="black", window_fill="gray10")
Plot(Month, Price, by1=Company, n_col=1, fill="darkred", color="red", trans=.55)

## ---------------------------------------------------------------------------------------------------------------------
style()
style(quiet=TRUE)

## ----fig.width=5------------------------------------------------------------------------------------------------------
Plot(Month, Price, by1=Company, xlab="", area_fill="on", area_origin=25)

## ----fig.width=5------------------------------------------------------------------------------------------------------
Plot(Month, Price, by1=Company, aspect=.5, area_fill="slategray3")

## ----fig.width=6------------------------------------------------------------------------------------------------------
Plot(Month, Price, by=Company, trans=0.4, stack=TRUE, area_fill="emeralds")

## ---------------------------------------------------------------------------------------------------------------------
dw <- reshape_wide(d, group="Company", response="Price", ID="Month")
head(dw)

## ----fig.width=6------------------------------------------------------------------------------------------------------
Plot(Month, c(Intel, Apple, IBM), area_fill="blues", stack=TRUE, trans=.4, data=dw)

## ----fig.wdith=6------------------------------------------------------------------------------------------------------
a1.ts <- ts(dw$Apple, frequency=12, start=c(1980, 12))
Plot(a1.ts)

## ---------------------------------------------------------------------------------------------------------------------
style()

## ----fig.width=4.5----------------------------------------------------------------------------------------------------
x <- as.Date("2007-06-01")
Plot(Month, Price, filter=(Company == "Apple"), fill="on",
            add=c("iPhone", "arrow"), 
            x1=c(x,x), y1=c(100,90), x2=x, y2=30)

