## ---------------------------------------------------------------------------------------------------------------------
library("lessR")

## ---------------------------------------------------------------------------------------------------------------------
d <- read.table(text="Severity Description
1 Mild
4 Moderate
3 Moderate
2 Mild
1 Severe", header=TRUE, stringsAsFactors=FALSE)

d

## ---------------------------------------------------------------------------------------------------------------------
d <- recode(Severity, old=1:4, new=c(10,20,30,40))
d

## ---------------------------------------------------------------------------------------------------------------------
d <- recode(Severity, new_vars="SevereNew", old=1:4, new=c(10,20,30,40))

## ---------------------------------------------------------------------------------------------------------------------
d <- Read("Mach4")
d <- recode(c(m01:m03,m10), old=0:5, new=5:0)

## ---------------------------------------------------------------------------------------------------------------------
d <- Read("Employee")
newdata <- recode(Plan, old=1, new="missing")

## ---------------------------------------------------------------------------------------------------------------------
head(d)

## ---------------------------------------------------------------------------------------------------------------------
d <- Read("Employee")
head(d)

## ---------------------------------------------------------------------------------------------------------------------
d <- recode(c(Years, Salary), old="missing", new=99)
head(d)

## ---------------------------------------------------------------------------------------------------------------------
d <- Read("Employee")
d <- d[1:12,]

## ---------------------------------------------------------------------------------------------------------------------
d <- Sort(d, Gender)
d

## ---------------------------------------------------------------------------------------------------------------------
d <- Sort(d, c(Gender, Salary), direction=c("+", "-"))
d

## ---------------------------------------------------------------------------------------------------------------------
d <- Sort(d, row.names)
d

## ---------------------------------------------------------------------------------------------------------------------
d <- Sort(d, random)
d

## ---------------------------------------------------------------------------------------------------------------------
rescale(Salary)

## ---------------------------------------------------------------------------------------------------------------------
d <- rd("Mach4", quiet=TRUE)
l <- rd("Mach4_lbl")
LikertCats <- c("Strongly Disagree", "Disagree", "Slightly Disagree",
                "Slightly Agree", "Agree", "Strongly Agree")

## ---------------------------------------------------------------------------------------------------------------------
d <- factors(m01:m20, levels=0:5, labels=LikertCats)

## ---------------------------------------------------------------------------------------------------------------------
d <- factors(c(m06, m07, m20), levels=0:5, labels=LikertCats, new=TRUE)

## ---------------------------------------------------------------------------------------------------------------------
l <- factors(c(m06, m07, m20), var_labels=TRUE)

