% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_lcp_density.R
\name{create_lcp_density}
\alias{create_lcp_density}
\title{creates a cumulative least-cost path raster}
\usage{
create_lcp_density(x, lcps, rescale = FALSE)
}
\arguments{
\item{x}{\code{SpatRaster}}

\item{lcps}{\code{sf} or \code{spatVector}}

\item{rescale}{\code{logical}. if TRUE, values scaled to between 0 and 1. FALSE (default)}
}
\value{
\code{SpatRaster}
}
\description{
Cumulatively combines least-cost paths to idenify routes of preferential movement
}
\examples{

r <- terra::rast(system.file("extdata/SICILY_1000m.tif", package="leastcostpath"))

slope_cs <- create_slope_cs(x = r, cost_function = "tobler", neighbours = 4)

locs <- sf::st_sf(geometry = sf::st_sfc(
sf::st_point(c(839769, 4199443)),
sf::st_point(c(1038608, 4100024)),
sf::st_point(c(907695, 4145478)),
crs = terra::crs(r)))

lcps <- create_FETE_lcps(x = slope_cs, locations = locs)

lcps_dens <- create_lcp_density(x = r, lcps = lcps)
}
\author{
Joseph Lewis
}
