% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_slope.R
\name{calculate_slope}
\alias{calculate_slope}
\title{calculate slope (rise over run) from supplied digital elevation model (DEM)}
\usage{
calculate_slope(dem, neighbours, exaggeration)
}
\arguments{
\item{dem}{\code{RasterLayer} (raster package). Digital Elevation Model}

\item{neighbours}{\code{numeric} value. Number of directions used in the Least Cost Path calculation. See Huber and Church (1985) for methodological considerations when choosing number of neighbours. Expected values are 4, 8, 16, 32, or 48. Default is 16}

\item{exaggeration}{\code{logical}. if TRUE, positive slope values (ie. up-hill movement) multiplied by 1.99 and negative slope values (ie. down-hill movement) multiplied by 2.31.}
}
\value{
\code{TransitionMatrix} (gdistance package). Anisotropic Slope (rise over run) Conductivity surface
}
\description{
calculate slope (rise over run) from supplied digital elevation model (DEM)
}
\author{
Joseph Lewis
}
