% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unit_models.R
\name{unit_cum_exact}
\alias{unit_cum_exact}
\title{Exact Cumulative Unit Learning Curve Function}
\usage{
unit_cum_exact(t, n, r, m = 1, na.rm = FALSE)
}
\arguments{
\item{t}{time (or cost) required for the mth unit of production}

\item{n}{The unit you wish to predict the cumulative time (or cost) to}

\item{r}{learning curve rate}

\item{m}{mth unit of production (default set to 1st production unit)}

\item{na.rm}{Should \code{NA} values be removed?}
}
\description{
Provides the exact cumulative time or cost required for units m through n (inclusive) using the Crawford unit model
}
\examples{
library(learningCurve)
# An estimator believes that the first unit of a product will 
# require 100 labor hours. How many total hours will be required
# for 125 units given the organization has historically experienced
# an 85\% learning curve?

unit_cum_exact(t = 100, n = 125, r = .85)
## [1] 5201.085
}

