% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hexbin.R
\name{addHexbin}
\alias{addHexbin}
\title{Add a Hexbin layer}
\usage{
addHexbin(
  map,
  lng = NULL,
  lat = NULL,
  radius = 20,
  layerId = NULL,
  group = NULL,
  opacity = 0.5,
  options = hexbinOptions(),
  data = getMapData(map)
)
}
\arguments{
\item{map}{a map widget object created from \code{\link[leaflet]{leaflet}()}}

\item{lng}{a numeric vector of longitudes, or a one-sided formula of the form
\code{~x} where \code{x} is a variable in \code{data}; by default (if not
explicitly provided), it will be automatically inferred from \code{data} by
looking for a column named \code{lng}, \code{long}, or \code{longitude}
(case-insensitively)}

\item{lat}{a vector of latitudes or a formula (similar to the \code{lng}
argument; the names \code{lat} and \code{latitude} are used when guessing
the latitude column from \code{data})}

\item{radius}{Radius of the hexbin layer}

\item{layerId}{the layer id}

\item{group}{the name of the group the newly created layers should belong to
(for \code{\link[leaflet]{clearGroup}} and \code{\link[leaflet]{addLayersControl}} purposes).
Human-friendly group names are permitted--they need not be short,
identifier-style names. Any number of layers and even different types of
layers (e.g. markers and polygons) can share the same group name.}

\item{opacity}{Opacity of the hexbin layer}

\item{options}{List of further options. See \code{\link{hexbinOptions}}}

\item{data}{the data object from which the argument values are derived; by
default, it is the \code{data} object provided to \code{leaflet()}
initially, but can be overridden}
}
\value{
the new \code{map} object
}
\description{
Create dynamic hexbin-based heatmaps on Leaflet maps. This plugin leverages
the data-binding power of d3 to allow you to dynamically update the data and
visualize the transitions.
}
\note{
Currently doesn't respect \code{layerId} nor \code{group}.
}
\examples{
library(leaflet)
library(leaflet.extras2)

n <- 1000
df <- data.frame(
  lat = rnorm(n, 42.0285, .01),
  lng = rnorm(n, -93.65, .01)
)

leaflet() \%>\%
  addTiles() \%>\%
  addHexbin(
    lng = df$lng, lat = df$lat,
    options = hexbinOptions(
      colorRange = c("red", "yellow", "blue"),
      radiusRange = c(10, 20)
    )
  )
}
\references{
\url{https://github.com/bluehalo/leaflet-d3#hexbins-api}
}
\seealso{
Other Hexbin-D3 Functions: 
\code{\link{clearHexbin}()},
\code{\link{hexbinOptions}()},
\code{\link{hideHexbin}()},
\code{\link{showHexbin}()},
\code{\link{updateHexbin}()}
}
\concept{Hexbin-D3 Functions}
