% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldhmm-class.R
\docType{class}
\name{ldhmm-class}
\alias{ldhmm-class}
\title{The ldhmm class}
\description{
This S4 class is the major object class for ldhmm package
}
\section{Slots}{

\describe{
\item{\code{call}}{The match.call slot}

\item{\code{m}}{numeric, length 1, number of states}

\item{\code{param.nbr}}{numeric, number of parameters (2 or 3) for each ecld object}

\item{\code{param}}{matrix, natural parameters for ecld objects, size of states times param.nbr.
Each row can be 2-parameter sequences, or 3-parameter sequences.
Three-parameter unit \code{(mu, sigma, lambda)} forms an ecld object
representing a leptokurtic symmetric lambda distribution.
On the other hand, to provide compatibility to a normal distribution HMM,
two-parameter unit \code{(mu, sigma)} forms an ecld object with lambda=1.}

\item{\code{gamma}}{matrix, the transition probability matrix, must be m by m.}

\item{\code{delta}}{numeric, the initial distribution for each state, default is \code{NULL}.}

\item{\code{stationary}}{logical, specify whether the initial distribution is stationary or not,
default is \code{TRUE}.}

\item{\code{mle.optimizer}}{character, the MLE optimizer. Currently it is just set to "nlm".}

\item{\code{return.code}}{numeric, the return code from the MLE optimizer.}

\item{\code{iterations}}{numeric, number of iterations MLE optimizer takes.}

\item{\code{mllk}}{numeric, the final mllk value.}

\item{\code{AIC}}{numeric, the final AIC.}

\item{\code{BIC}}{numeric, the final BIC.}

\item{\code{observations}}{numeric, stores the observations post optimization}

\item{\code{states.prob}}{matrix, stores the state probabilities post optimization}

\item{\code{states.local}}{numeric, stores the local decoding states post optimization}

\item{\code{states.global}}{numeric, stores the global decoding states post optimization (Viterbi)}

\item{\code{states.local.stats}}{matrix, stores the statistics of local states post optimization}

\item{\code{states.global.stats}}{matrix, stores the statistics of global states post optimization}
}}
\keyword{class}
\keyword{constructor}

