% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{lawn_merge}
\alias{lawn_merge}
\title{Merge polygons}
\usage{
lawn_merge(fc, lint = FALSE)
}
\arguments{
\item{fc}{Input polygons, as \link{data-FeatureCollection}.}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
Merged \link{data-Polygon} or multipolygon
\link{data-MultiPolygon}.
}
\description{
Takes a set of \link{data-Polygon}'s and returns a single
merged polygon feature. If the input polygon features are not contiguous,
returns a \link{data-MultiPolygon} feature.
}
\examples{
polygons <- '{
  "type": "FeatureCollection",
  "features": [
    {
      "type": "Feature",
      "properties": {
        "fill": "#0f0"
      },
      "geometry": {
        "type": "Polygon",
        "coordinates": [[
          [9.994812, 53.549487],
          [10.046997, 53.598209],
          [10.117721, 53.531737],
          [9.994812, 53.549487]
        ]]
      }
    }, {
      "type": "Feature",
      "properties": {
        "fill": "#00f"
      },
      "geometry": {
        "type": "Polygon",
        "coordinates": [[
          [10.000991, 53.50418],
          [10.03807, 53.562539],
          [9.926834, 53.551731],
          [10.000991, 53.50418]
        ]]
      }
    }
  ]
}'
lawn_merge(polygons)
\dontrun{
lawn_featurecollection(polygons) \%>\% view
lawn_merge(polygons) \%>\% view
}
}
\seealso{
\link{lawn_union}

Other transformations: 
\code{\link{lawn_bezier}()},
\code{\link{lawn_buffer}()},
\code{\link{lawn_concave}()},
\code{\link{lawn_convex}()},
\code{\link{lawn_difference}()},
\code{\link{lawn_intersect}()},
\code{\link{lawn_simplify}()},
\code{\link{lawn_union}()}
}
\concept{transformations}
