% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/truncate.R
\name{lawn_truncate}
\alias{lawn_truncate}
\title{Truncate}
\usage{
lawn_truncate(x, precision = 6, coordinates = 2, lint = FALSE)
}
\arguments{
\item{x}{any \link{data-Feature} or \link{data-FeatureCollection}}

\item{precision}{(integer) coordinate decimal precision. default: 6}

\item{coordinates}{(integer) maximum number of coordinates (primarily used
to remove z coordinates). default: 2}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
a \link{data-Feature} or \link{data-FeatureCollection} with truncated geometry
}
\description{
Takes a GeoJSON Feature or FeatureCollection and truncates the precision
of the geometry.
}
\examples{
cat(lawn_data$filter_features)
lawn_coordall(lawn_data$filter_features)
lawn_truncate(lawn_data$filter_features, 4) \%>\% lawn_coordall
lawn_truncate(lawn_data$filter_features, 2) \%>\% lawn_coordall
lawn_truncate(lawn_data$filter_features, 4, 1) \%>\% lawn_coordall
}
\seealso{
Other misc: \code{\link{lawn_flatten}}
}
\concept{misc}
