% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{fittedTrajectories}
\alias{fittedTrajectories}
\alias{fittedTrajectories,lcModel-method}
\title{Extract the fitted trajectories for all strata}
\usage{
\S4method{fittedTrajectories}{lcModel}(
  object,
  at = time(object),
  what = "mu",
  clusters = trajectoryAssignments(object),
  ...
)
}
\arguments{
\item{object}{The model.}

\item{at}{The time points at which to compute the id-specific trajectories.
The default implementation merely filters the output of \code{fitted()},
so fitted values can only be outputted for times at which the model was trained.}

\item{what}{The distributional parameter to compute the response for.}

\item{clusters}{The cluster assignments for the strata to base the trajectories on.}

\item{...}{Additional arguments.}
}
\value{
A \code{data.frame} representing the fitted response per trajectory per moment in time for the respective cluster.
}
\description{
Extract the fitted trajectories for all strata
}
\details{
The default implementation uses the output of \code{fitted()} of the respective model.
}
\examples{
data(latrendData)
# Note: not a great example because the fitted trajectories
# are identical to the respective cluster trajectory
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
model <- latrend(method, latrendData)
fittedTrajectories(model)

fittedTrajectories(model, at = time(model)[c(1, 2)])
}
\seealso{
Other model-specific methods: 
\code{\link{clusterTrajectories}()},
\code{\link{coef.lcModel}()},
\code{\link{converged}()},
\code{\link{deviance.lcModel}()},
\code{\link{df.residual.lcModel}()},
\code{\link{fitted.lcModel}()},
\code{\link{lcModel-class}},
\code{\link{logLik.lcModel}()},
\code{\link{model.frame.lcModel}()},
\code{\link{nobs.lcModel}()},
\code{\link{postprob}()},
\code{\link{predict.lcModel}()},
\code{\link{predictAssignments}()},
\code{\link{predictForCluster}()},
\code{\link{predictPostprob}()},
\code{\link{residuals.lcModel}()},
\code{\link{sigma.lcModel}()},
\code{\link{time.lcModel}()}
}
\concept{model-specific methods}
