% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latrend.R
\name{createTrainDataFolds}
\alias{createTrainDataFolds}
\title{Create the training data for each of the k models in k-fold cross validation evaluation}
\usage{
createTrainDataFolds(
  data,
  folds = 10L,
  id = getOption("latrend.id"),
  seed = NULL
)
}
\arguments{
\item{data}{A \code{data.frame} representing the complete dataset.}

\item{folds}{The number of folds. By default, a 10-fold scheme is used.}

\item{id}{The trajectory identifier variable.}

\item{seed}{The seed to use, in order to ensure reproducible fold generation at a later moment.}
}
\value{
A \code{list} of \code{data.frame} of the \code{folds} training datasets.
}
\description{
Create the training data for each of the k models in k-fold cross validation evaluation
}
\examples{
data(latrendData)

if (require("caret")) {
  trainFolds <- createTrainDataFolds(latrendData, folds = 10, id = "Id")

  trainFolds <- createTrainDataFolds(latrendData, folds = 10, id = "Id", seed = 1)
}
}
\seealso{
Other validation methods: 
\code{\link{createTestDataFolds}()},
\code{\link{createTestDataFold}()},
\code{\link{latrendBoot}()},
\code{\link{latrendCV}()},
\code{\link{lcModel-data-filters}}
}
\concept{validation methods}
