% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R, R/model.R
\name{responseVariable}
\alias{responseVariable}
\alias{responseVariable,lcMethod-method}
\alias{responseVariable,lcModel-method}
\title{Extract the response variable}
\usage{
\S4method{responseVariable}{lcMethod}(object, ...)

\S4method{responseVariable}{lcModel}(object, ...)
}
\arguments{
\item{object}{The object to extract the response variable from.}

\item{...}{Additional arguments.}
}
\value{
The response variable name as a \code{character}.
}
\description{
Extracts the response variable from the given \code{object}.
}
\details{
If the \code{lcMethod} object specifies a \code{formula} argument, then the response is extracted from the response term of the formula.
}
\examples{
method <- lcMethodLMKM(Y ~ Time)
responseVariable(method) # "Y"
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
model <- latrend(method, latrendData)
responseVariable(model) # "Y"
}
\seealso{
Other lcModel variables: 
\code{\link{idVariable}()},
\code{\link{timeVariable}()}
}
\concept{lcModel variables}
