% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R, R/model.R
\name{plotTrajectories}
\alias{plotTrajectories}
\alias{plotTrajectories,data.frame-method}
\alias{plotTrajectories,lcModel-method}
\title{Plot trajectories}
\usage{
\S4method{plotTrajectories}{data.frame}(
  object,
  response,
  time = getOption("latrend.time"),
  id = getOption("latrend.id"),
  cluster = NULL,
  facet = TRUE,
  ...
)

\S4method{plotTrajectories}{lcModel}(object, ...)
}
\arguments{
\item{object}{The model.}

\item{response}{Response variable \code{character} name or a \code{call}.}

\item{time}{The name of the time variable.}

\item{id}{The name of the trajectory identifier variable.}

\item{cluster}{Cluster variable name. If unspecified, trajectories are not grouped. Alternatively, cluster is a vector indicating cluster membership per id.}

\item{facet}{Whether to facet by cluster.}

\item{...}{
  Arguments passed on to \code{\link[=trajectories]{trajectories}}
  \describe{
    \item{\code{at}}{The time points at which to compute the id-specific trajectories.}
    \item{\code{what}}{The distributional parameter to compute the response for.}
    \item{\code{clusters}}{The cluster assignments for the strata to base the trajectories on.}
  }}
}
\description{
Plot trajectories

Plot fitted trajectories of a lcModel
}
\examples{
data(latrendData)
plotTrajectories(latrendData, response = "Y", id = "Id", time = "Time")

plotTrajectories(latrendData, response = quote(exp(Y)), id = "Id", time = "Time")
}
