\name{ergmm.object}
\alias{ergmm.object}
\alias{print.ergmm}
\alias{show.ergmm}
\title{Class of Fitted Exponential Random Graph Mixed Models}
\description{
  A class \code{\link[=ergmm.object]{ergmm}} to represent a fitted exponential random graph
  mixed model. The output of \code{\link{ergmm}}.
}
\details{
  There are methods \code{\link{summary.ergmm}}, \code{print.ergmm},
  \code{\link{plot.ergmm}}, \code{\link{predict.ergmm}},
  \code{\link{as.mcmc.ergmm}}, and \code{\link{as.mcmc.list.ergmm}}.
  
  The structure of \code{ergmm} is as follows:
  \describe{
     \item{\code{sample}}{ An object of class \code{\link[=ergmm.par.list.object]{ergmm.par.list}} containing the
    MCMC sample from the posterior. If the run had multiple threads, their output is concatenated.}
     \item{\code{mcmc.mle}}{ A list containing the parameter
    configuration of the highest-likelihood MCMC iteration. }
     \item{\code{mcmc.pmode}}{ A list containing the parameter
    configuration of the highest-joint-density (conditional on cluster
    assignments) MCMC iteration. }
     \item{\code{mkl}}{ A list containing the MKL estimate. }
     \item{\code{model}}{ A list containing the model
    that was fitted.}
     \item{\code{prior}}{ A list containing the
    information about the prior distribution used. It can be passed as
    parameter \code{prior} to \code{\link{ergmm}} to reproduce the prior
    in a new fit.}
     \item{\code{control}}{ A list containing the
    information about the model fit settings that do not affect the
    posterior distribution. It can be passed as
    parameter \code{control} to \code{\link{ergmm}} to reproduce control
    parameters in a new fit.}
     \item{\code{mle}}{ A list containing the MLE,
    conditioned on cluster assignments.}
     \item{\code{pmode}}{ A list containing the posterior mode,
    conditioned on cluster assignments.}
     \item{\code{burnin.start}}{ A list containing the starting
    value for the burnin.}
     \item{\code{main.start}}{  A list (or a list of lists, for a
    multithreaded run) containing the starting
    value for the sampling. }
  }
}
\seealso{
  \code{\link{ergmm}},
  \code{\link{summary.ergmm}},
  \code{\link{plot.ergmm}},
  \code{\link{predict.ergmm}},
  \code{\link{as.mcmc.ergmm}},
  \code{\link{as.mcmc.list.ergmm}}
}
\keyword{graphs}
\keyword{regression}
\keyword{models}