# Example 1 - truncated data type, same type for all variables
# Generate data
X = gen_data(n = 300, types = rep("tru", 5))$X
# Estimate latent correlation matrix with original method and check the timing
start_time = proc.time()
R_nc_org = latentcor(X = X, types = "tru", method = "original")$R
proc.time() - start_time
# # Estimate latent correlation matrix with approximation method and check the timing
# start_time = proc.time()
# R_nc_approx = latentcor(X = X, types = "tru", method = "approx")$R
# proc.time() - start_time
# # Heatmap for latent correlation matrix.
# Heatmap_R_nc_approx = latentcor(X = X, types = "tru", method = "approx",
#                                 showplot = TRUE)$plotR

# Example 2 - ternary/continuous case
X = gen_data()$X
# Estimate latent correlation matrix with original method
R_nc_org = latentcor(X = X, types = c("ter", "con"), method = "original")$R
# # Estimate latent correlation matrix with aprroximation method
# R_nc_approx = latentcor(X = X, types = c("ter", "con"), method = "approx")$R
