% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exports.R
\name{readList}
\alias{readList}
\title{Get elements from a list file.}
\usage{
readList(file, index = NULL)
}
\arguments{
\item{file}{Name of file.}

\item{index}{\code{NULL} or a numeric, character, logical vector.}
}
\value{
A list object.
}
\description{
Get elements from a list file.
}
\details{
If no indices provided, the whole list will be read. Given index could be a numeric (integer) 
vector, a logical vector or a character vector representing the names. If there exist more then one elements 
corresponding to a given name, the first matched will be returned (not necessary to be the first
one in index order). If there are no elements with given name, \code{NULL} will be returned. \cr
Files created by \code{\link{saveRDS}} can't be read. \cr
When it takes long time to process, some verbose info will be printed to console, 
which can be switched off by setting \code{options(list(largeList.report.progress = FALSE))}.
}
\examples{
list_1 <- list("A" = c(1,2), "B" = "abc", list(1, 2, 3))
saveList(object = list_1, file = "example.llo")

# read the whole list
readList(file = "example.llo")

# by numeric indices
readList(file = "example.llo", index = c(1, 3))

# by names
readList(file = "example.llo", index = c("A", "B"))

# by logical indices
readList(file = "example.llo", index = c(TRUE, FALSE, TRUE))

}
\seealso{
\code{\link{largeList}}
}
