% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stocks.R
\name{weighted_value}
\alias{weighted_value}
\title{Calculate weighted stock values using FIFO/LIFO}
\usage{
weighted_value(
  value,
  n = rep(1, length(value)),
  technique = NULL,
  n_stocks = NULL,
  buy_only = TRUE,
  type = 1,
  ...
)
}
\arguments{
\item{value}{Numeric vector. Representing the values of the stock.}

\item{n}{Numeric vector. Representing the volume of the operation.
Positive for 'Buy' and negative for 'Sale'.}

\item{technique}{Character. Pick any of FIFO or LIFO, or NULL to skip.}

\item{n_stocks}{Integer. Specify the number of stocks to consider. By
default will sum positive values of \code{n}.}

\item{buy_only}{Boolean. Consider only buy (positive) values?}

\item{type}{Integer. 1 for returning the value, 2 for returning the
data.frame with the details ("df" attribute)}

\item{...}{Additional parameters.}
}
\value{
The calculated weighted mean value.
}
\description{
Calculate weighted stock values using FIFO/LIFO
}
\examples{
values <- c(10, 20, 30, 40, 50)
weights <- c(2, 3, -4, 5, 6)
mean(values)
weighted_value(values)
weighted.mean(values, weights)
weighted_value(values, weights, buy_only = FALSE)
# Using FIFO and LIFO
weighted_value(values, weights, "FIFO")
weighted_value(values, weights, "LIFO", n_stocks = 8)
}
