% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlations.R
\name{corr_cross}
\alias{corr_cross}
\title{Ranked cross-correlation across all variables}
\usage{
corr_cross(
  df,
  plot = TRUE,
  pvalue = TRUE,
  max_pvalue = 1,
  type = 1,
  max = 1,
  top = 20,
  local = 1,
  ignore = NULL,
  contains = NA,
  grid = TRUE,
  rm.na = FALSE,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{df}{Dataframe. It doesn't matter if it's got non-numerical
columns: they will be filtered.}

\item{plot}{Boolean. Show and return a plot?}

\item{pvalue}{Boolean. Returns a list, with correlations and statistical
significance (p-value) for each value.}

\item{max_pvalue}{Numeric. Filter non-significant variables. Range (0, 1]}

\item{type}{Integer. Plot type. 1 is for overall rank. 2 is for local rank.}

\item{max}{Numeric. Maximum correlation permitted (from 0 to 1)}

\item{top}{Integer. Return top n results only. Only valid when type = 1. Set
value to NA to use all cross-correlations}

\item{local}{Integer. Label top n local correlations. Only valid when type = 2}

\item{ignore}{Vector or character. Which column should be ignored?}

\item{contains}{Character vector. Filter cross-correlations
with variables that contains certain strings (using any value if vector used).}

\item{grid}{Boolean. Separate into grids?}

\item{rm.na}{Boolean. Remove NAs?}

\item{quiet}{Boolean. Keep quiet? If not, show messages}

\item{...}{Additional parameters passed to \code{corr}}
}
\value{
Depending on input \code{plot}, we get correlation and p-value results for
every combination of features, arranged by descending absolute correlation value,
with a data.frame \code{plot = FALSE} or plot \code{plot = TRUE}.
}
\description{
This function creates a correlation full study and returns a rank
of the highest correlation variables obtained in a cross-table.
}
\details{
DataScience+ Post:
\href{https://datascienceplus.com/find-insights-with-ranked-cross-correlations/}{Find
Insights with Ranked Cross-Correlations}
}
\examples{
Sys.unsetenv("LARES_FONT") # Temporal
data(dft) # Titanic dataset

# Only data with no plot
corr_cross(dft, plot = FALSE, top = 10)

# Show only most relevant results filtered by pvalue
corr_cross(dft, rm.na = TRUE, max_pvalue = 0.05, top = 15)

# Cross-Correlation for certain variables
corr_cross(dft, contains = c("Survived", "Fare"))

# Cross-Correlation max values per category
corr_cross(dft, type = 2, top = NA)
}
\seealso{
Other Correlations: 
\code{\link{corr}()},
\code{\link{corr_var}()}

Other Exploratory: 
\code{\link{corr_var}()},
\code{\link{crosstab}()},
\code{\link{df_str}()},
\code{\link{distr}()},
\code{\link{freqs}()},
\code{\link{freqs_df}()},
\code{\link{freqs_list}()},
\code{\link{freqs_plot}()},
\code{\link{lasso_vars}()},
\code{\link{missingness}()},
\code{\link{plot_cats}()},
\code{\link{plot_df}()},
\code{\link{plot_nums}()},
\code{\link{tree_var}()}
}
\concept{Correlations}
\concept{Exploratory}
