% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_metrics.R
\name{model_metrics}
\alias{model_metrics}
\title{Model Metrics and Performance}
\usage{
model_metrics(
  tag,
  score,
  multis = NA,
  abc = TRUE,
  thresh = 10,
  thresh_cm = 0.5,
  target = "auto",
  type = "test",
  model_name = NA,
  plots = TRUE,
  subtitle = NA
)
}
\arguments{
\item{tag}{Vector. Real known label}

\item{score}{Vector. Predicted value or model's result}

\item{multis}{Data.frame. Containing columns with each category score 
(only used when more than 2 categories coexist)}

\item{abc}{Boolean. Arrange columns and rows alphabetically 
when categorical values?}

\item{thresh}{Integer. Threshold for selecting binary or regression 
models: this number is the threshold of unique values we should 
have in 'tag' (more than: regression; less than: classification)}

\item{thresh_cm}{Numeric. Value to splits the results for the 
confusion matrix. Range of values: (0-1)}

\item{target}{Value. Which is your target positive value? If 
set to 'auto', the target with largest mean(score) will be 
selected. Change the value to overwrite. Only used when binary
categorical model.}

\item{type}{Character. One of: "train", "test".}

\item{model_name}{Character. Model's name}

\item{plots}{Boolean. Include plots?}

\item{subtitle}{Character. Subtitle for plots}
}
\value{
List. Multiple performance metrics that vary depending on
the type of model (classification or regression). If \code{plot=TRUE},
multiple plots are also returned.
}
\description{
This function lets the user get a confusion matrix and accuracy, and 
for for binary classification models: AUC, Precision, Sensitivity, and
Specificity, given the expected (tags) values and predicted values (scores).
}
\examples{
data(dfr) # Results for AutoML Predictions
lapply(dfr, head)

# Metrics for Binomial Model
met1 <- model_metrics(dfr$class2$tag, dfr$class2$scores,
                      model_name = "Titanic Survived Model",
                      plots = FALSE)
print(met1)

# Metrics for Multi-Categorical Model
met2 <- model_metrics(dfr$class3$tag, dfr$class3$score,
                      multis = subset(dfr$class3, select = -c(tag, score)),
                      model_name = "Titanic Class Model",
                      plots = FALSE)
print(met2)
          
# Metrics for Regression Model
met3 <- model_metrics(dfr$regr$tag, dfr$regr$score,
                      model_name = "Titanic Fare Model",
                      plots = FALSE)
print(met3)
}
\seealso{
Other Machine Learning: 
\code{\link{ROC}()},
\code{\link{conf_mat}()},
\code{\link{export_results}()},
\code{\link{gain_lift}()},
\code{\link{h2o_automl}()},
\code{\link{h2o_predict_API}()},
\code{\link{h2o_predict_MOJO}()},
\code{\link{h2o_predict_binary}()},
\code{\link{h2o_predict_model}()},
\code{\link{h2o_selectmodel}()},
\code{\link{impute}()},
\code{\link{iter_seeds}()},
\code{\link{lasso_vars}()},
\code{\link{model_preprocess}()},
\code{\link{msplit}()}

Other Model metrics: 
\code{\link{ROC}()},
\code{\link{conf_mat}()},
\code{\link{errors}()},
\code{\link{gain_lift}()},
\code{\link{loglossBinary}()}

Other Calculus: 
\code{\link{corr}()},
\code{\link{dist2d}()},
\code{\link{quants}()}
}
\concept{Calculus}
\concept{Machine Learning}
\concept{Model metrics}
