% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_functions.R
\name{numericalonly}
\alias{numericalonly}
\title{Select only numerical columns in a dataframe}
\usage{
numericalonly(df, dropnacols = TRUE, logs = FALSE, natransform = NA)
}
\arguments{
\item{df}{Data.frame}

\item{dropnacols}{Boolean. Drop columns with only NA values?}

\item{logs}{Boolean. Calculate log(x)+1 for numerical columns?}

\item{natransform}{String. "mean" or 0 to impute NA values. If
set to NA no calculation will run.}
}
\value{
data.frame with all numerical columns selected.
}
\description{
Select only numerical columns in a dataframe
}
\examples{
data(dft) # Titanic dataset
str(dft)
numericalonly(dft) \%>\% head()
numericalonly(dft, natransform = "mean") \%>\% head()
}
\seealso{
Other Data Wrangling: 
\code{\link{balance_data}()},
\code{\link{categ_reducer}()},
\code{\link{cleanText}()},
\code{\link{date_cuts}()},
\code{\link{date_feats}()},
\code{\link{formatNum}()},
\code{\link{holidays}()},
\code{\link{impute}()},
\code{\link{left}()},
\code{\link{normalize}()},
\code{\link{ohe_commas}()},
\code{\link{ohse}()},
\code{\link{removenacols}()},
\code{\link{removenarows}()},
\code{\link{replaceall}()},
\code{\link{textFeats}()},
\code{\link{textTokenizer}()},
\code{\link{vector2text}()},
\code{\link{year_month}()},
\code{\link{year_week}()}
}
\concept{Data Wrangling}
