% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_contig_mn.R
\name{lsm_c_contig_mn}
\alias{lsm_c_contig_mn}
\title{CONTIG_MN (class level)}
\usage{
lsm_c_contig_mn(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick, SpatRaster (terra), stars, or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Mean of Contiguity index (Shape metric)
}
\details{
\deqn{CONTIG_{MN} =  mean(CONTIG[patch_{ij}])}

where \eqn{CONTIG[patch_{ij}]} is the contiguity of each patch.

CONTIG_MN is a 'Shape metric'. It summarises each class as the mean of each patch
belonging to class i. CONTIG_MN asses the spatial connectedness (contiguity) of
cells in patches. The metric coerces patch values to a value of 1 and the background
to NA. A nine cell focal filter matrix:

\if{html}{\out{<div class="sourceCode">}}\preformatted{filter_matrix <- matrix(c(1, 2, 1,
                          2, 1, 2,
                          1, 2, 1), 3, 3, byrow = T)
}\if{html}{\out{</div>}}

... is then used to weight orthogonally contiguous pixels more heavily than
diagonally contiguous pixels. Therefore, larger and more connections between
patch cells in the rookie case result in larger contiguity index values.

\subsection{Units}{None}
\subsection{Range}{0 >= CONTIG_MN <= 1}
\subsection{Behaviour}{CONTIG equals the mean of the contiguity index on class level for all
patches.}
}
\examples{
lsm_c_contig_mn(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: https://www.umass.edu/landeco/

LaGro, J. 1991. Assessing patch shape in landscape mosaics.
Photogrammetric Engineering and Remote Sensing, 57(3), 285-293
}
\seealso{
\code{\link{lsm_p_contig}},
\code{\link{lsm_c_contig_sd}},
\code{\link{lsm_c_contig_cv}}, \cr
\code{\link{lsm_l_contig_mn}},
\code{\link{lsm_l_contig_sd}},
\code{\link{lsm_l_contig_cv}}
}
