% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_cohesion.R
\name{lsm_c_cohesion}
\alias{lsm_c_cohesion}
\title{COHESION (class level)}
\usage{
lsm_c_cohesion(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick, SpatRaster (terra), stars, or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Patch Cohesion Index (Aggregation metric)
}
\details{
\deqn{COHESION = 1 - (\frac{\sum \limits_{j = 1}^{n} p_{ij}} {\sum \limits_{j = 1}^{n} p_{ij} \sqrt{a_{ij}}}) * (1 - \frac{1} {\sqrt{Z}}) ^ {-1} * 100}
where \eqn{p_{ij}} is the perimeter in meters, \eqn{a_{ij}} is the area in square
meters and \eqn{Z} is the number of cells.

COHESION is an 'Aggregation metric'. It characterises the connectedness of patches
belonging to class i. It can be used to asses if patches of the same class are located
aggregated or rather isolated and thereby COHESION gives information about the
configuration of the landscape.

\subsection{Units}{Percent}
\subsection{Ranges}{0 < COHESION < 100}
\subsection{Behaviour}{Approaches COHESION = 0 if patches of class i become more isolated.
Increases if patches of class i become more aggregated.}
}
\examples{
lsm_c_cohesion(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: https://www.umass.edu/landeco/

Schumaker, N. H. 1996. Using landscape indices to predict habitat
connectivity. Ecology, 77(4), 1210-1225.
}
\seealso{
\code{\link{lsm_p_perim}},
\code{\link{lsm_p_area}}, \cr
\code{\link{lsm_l_cohesion}}
}
