% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_c_clumpy.R
\name{lsm_c_clumpy}
\alias{lsm_c_clumpy}
\title{CLUMPY (class level)}
\usage{
lsm_c_clumpy(landscape)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick, SpatRaster (terra), stars, or a list of rasterLayers}
}
\value{
tibble
}
\description{
Clumpiness index (Aggregation metric)
}
\details{
\deqn{Given G_{i} = \Bigg(\frac{g_{ii}}{ (\sum\limits_{k=1}^m g_{ik}) - min e_{i}} \Bigg)}
\deqn{CLUMPY = \Bigg[ \frac{G_{i} - P_{i}}{P_{i}} for G_{i} < P_{i} \& P_{i} < .5; else \\  \frac{G_{i} - P_{i}}{1 -P_{i}} \Bigg] }

where \eqn{g_{ii}} is the number of like adjacencies, \eqn{g_{ik}} is the classwise
number of all adjacencies including the focal class, \eqn{min e_{i}} is the
minimum perimeter of the total class in terms of cell surfaces assuming total clumping and
\eqn{P_{i}} is the proportion of landscape occupied by each class.

CLUMPY is an 'Aggregation metric'. It equals the proportional deviation of
the proportion of like adjacencies involving the corresponding class from that expected
under a spatially random distribution. The metric is based on he adjacency matrix and the
the double-count method.

\subsection{Units}{None}, directions = directions
\subsection{Range}{-1 <= CLUMPY <= 1}
\subsection{Behaviour}{Equals -1 for maximally disaggregated, 0 for randomly distributed
and 1 for maximally aggregated classes.}
}
\examples{
lsm_c_clumpy(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: https://www.umass.edu/landeco/
}
