% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_gyrate_sd.R
\name{lsm_l_gyrate_sd}
\alias{lsm_l_gyrate_sd}
\alias{lsm_l_gyrate_sd.RasterLayer}
\alias{lsm_l_gyrate_sd.RasterStack}
\alias{lsm_l_gyrate_sd.RasterBrick}
\alias{lsm_l_gyrate_sd.stars}
\alias{lsm_l_gyrate_sd.list}
\title{GYRATE_SD (landscape level)}
\usage{
lsm_l_gyrate_sd(landscape, directions)

\method{lsm_l_gyrate_sd}{RasterLayer}(landscape, directions = 8)

\method{lsm_l_gyrate_sd}{RasterStack}(landscape, directions = 8)

\method{lsm_l_gyrate_sd}{RasterBrick}(landscape, directions = 8)

\method{lsm_l_gyrate_sd}{stars}(landscape, directions = 8)

\method{lsm_l_gyrate_sd}{list}(landscape, directions = 8)
}
\arguments{
\item{landscape}{Raster* Layer, Stack, Brick or a list of rasterLayers.}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}
}
\value{
tibble
}
\description{
Standard deviation radius of gyration (Area and edge metric)
}
\details{
\deqn{GYRATE_{SD} = sd(GYRATE[patch_{ij}])}
where \eqn{GYRATE[patch_{ij}]} equals the radius of gyration of each patch.

GYRATE_SD is an 'Area and edge metric'. The metric summarises the landscape
as the standard deviation of the radius of gyration of all patches
in the landscape. GYRATE measures the distance from each cell to the patch
centroid and is based on cell center-to-cell center distances. The metrics characterises
both the patch area and compactness.

\subsection{Units}{Meters}
\subsection{Range}{GYRATE_SD >= 0 }
\subsection{Behaviour}{Equals GYRATE_SD = 0 if the radius of gyration is identical
for all patches. Increases, without limit, as the variation of the radius of gyration
increases.}
}
\examples{
lsm_l_gyrate_sd(landscape)

}
\references{
McGarigal, K., SA Cushman, and E Ene. 2012. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical and Continuous Maps. Computer software program produced by
the authors at the University of Massachusetts, Amherst. Available at the following
web site: http://www.umass.edu/landeco/research/fragstats/fragstats.html

Keitt, T. H., Urban, D. L., & Milne, B. T. 1997. Detecting critical scales
in fragmented landscapes. Conservation ecology, 1(1).
}
\seealso{
\code{\link{lsm_p_gyrate}},
\code{\link{cv}}, \cr
\code{\link{lsm_c_gyrate_mn}},
\code{\link{lsm_c_gyrate_sd}},
\code{\link{lsm_c_gyrate_cv}}, \cr
\code{\link{lsm_l_gyrate_mn}},
\code{\link{lsm_l_gyrate_cv}}
}
