% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_lsm.R
\name{show_lsm}
\alias{show_lsm}
\alias{show_lsm.RasterLayer}
\alias{show_lsm.RasterStack}
\alias{show_lsm.RasterBrick}
\alias{show_lsm.stars}
\alias{show_lsm.list}
\title{Show landscape metrics}
\usage{
show_lsm(landscape, what, class, directions, consider_boundary, edge_depth,
  labels, label_lsm, nrow, ncol)

\method{show_lsm}{RasterLayer}(landscape, what, class = "global",
  directions = 8, consider_boundary = FALSE, edge_depth = 1,
  labels = TRUE, label_lsm = FALSE, nrow = NULL, ncol = NULL)

\method{show_lsm}{RasterStack}(landscape, what, class = "global",
  directions = 8, consider_boundary = FALSE, edge_depth = 1,
  labels = TRUE, label_lsm = FALSE, nrow = NULL, ncol = NULL)

\method{show_lsm}{RasterBrick}(landscape, what, class = "global",
  directions = 8, consider_boundary = FALSE, edge_depth = 1,
  labels = TRUE, label_lsm = FALSE, nrow = NULL, ncol = NULL)

\method{show_lsm}{stars}(landscape, what, class = "global",
  directions = 8, consider_boundary = FALSE, edge_depth = 1,
  labels = TRUE, label_lsm = FALSE, nrow = NULL, ncol = NULL)

\method{show_lsm}{list}(landscape, what, class = "global",
  directions = 8, consider_boundary = FALSE, edge_depth = 1,
  labels = TRUE, label_lsm = FALSE, nrow = NULL, ncol = NULL)
}
\arguments{
\item{landscape}{*Raster object}

\item{what}{Patch level what to plot}

\item{class}{How to show the labeled patches: "global" (single map), "all" (every class as facet),
or a vector with the specific classes one wants to show (every selected class as facet).}

\item{directions}{The number of directions in which patches should be
connected: 4 (rook's case) or 8 (queen's case).}

\item{consider_boundary}{Logical if cells that only neighbour the landscape boundary should be considered as core}

\item{edge_depth}{Distance (in cells) a cell has the be away from the patch edge to be considered as core cell}

\item{labels}{Logical flag indicating whether to print or not to print patch labels.}

\item{label_lsm}{If true, the value of the landscape metric is used as label}

\item{nrow, ncol}{Number of rows and columns for the facet.}
}
\value{
ggplot
}
\description{
Show landscape metrics on patch level printed in their corresponding patch.
}
\details{
The function plots all patches with a fill corresponding to the value of the chosen landscape metric on patch level.
}
\examples{
show_lsm(landscape, what = "lsm_p_area", directions = 4)
show_lsm(landscape, what = "lsm_p_shape", class = c(1, 2), label_lsm = TRUE)
show_lsm(landscape, what = "lsm_p_circle", class = 3, labels = TRUE)

}
